<?php
/**
 * Astra Child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra Child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_ASTRA_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_ASTRA_CHILD_VERSION, 'all' );
	wp_enqueue_style( 'main-custom-css', get_stylesheet_directory_uri() . '/custom-css/main.css');
    
   wp_enqueue_style( 'main-custom-fonts', get_stylesheet_directory_uri() . '/custom-fonts/main-fonts.css');

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

//Editor 

add_filter('use_block_editor_for_post', '__return_false', 10);


//plugin prevent cache, crea versiones diferentes de los estilos y js
prevent_browser_caching( array( 
    'assets_version' => 'septiembre-11-2022' 
) );

/* -------------------------------------------- CARRITO */

function custom_override_default_locale_fields( $fields ) {
   $fields['first_name']['priority'] = 1;
   $fields['last_name']['priority'] = 2;
   $fields['company']['priority'] = 3;
   $fields['adress_2']['priority'] = 4;
   $fields['country']['priority'] = 5;
   $fields['state']['priority'] = 6;
   $fields['city']['priority'] = 7;
   $fields['address_1']['priority'] = 8;
   $fields['phone']['priority'] = 9;
   $fields['email']['priority'] = 10;

   return $fields;
}

add_filter( 'woocommerce_default_address_fields', 'custom_override_default_locale_fields' );

function tf_custom_checkout_shipping_fields( $fields ) {

       /* Borrar campos */

       unset($fields['billing']['billing_postcode']);
       //unset($fields['billing']['billing_adress_2']);
       //unset($fields['billing']['billing_state']);
       //unset($fields['billing']['billing_city']);
       //unset($fields['billing']['billing_address_1']);

       unset($fields['shipping']['shipping_company']);
       unset($fields['shipping']['shipping_adress_2']);
       unset($fields['shipping']['shipping_address_2']);
       unset($fields['shipping']['shipping_postcode']);

       $fields['shipping']['shipping_phone']['placeholder'] = 'Número de móvil preferiblemente';
       $fields['shipping']['shipping_email']['placeholder'] = 'Correo electrónico';

       $fields['billing']['billing_phone']['placeholder'] = 'Número de móvil preferiblemente';
       //$fields['billing']['billing_adress_2']['placeholder'] = 'ej: C.C 123456789';
       //$fields['billing']['billing_adress_2']['required'] = true;

       return $fields;

   }

add_filter( 'woocommerce_checkout_fields' , 'tf_custom_checkout_shipping_fields' );

add_filter( 'woocommerce_default_address_fields' , 'override_default_address_fields' );
function override_default_address_fields( $address_fields ) {

   // @ for city
   //$address_fields['city']['class'] = array('form-row-first');
   $address_fields['city']['label'] = __('Ciudad', 'woocommerce');

   $address_fields['state']['label'] = __('Departamento', 'woocommerce');
   $address_fields['address_1']['label'] = __('Dirección del envío', 'woocommerce');
   $address_fields['adress_2']['label'] = __('Documento de identidad', 'woocommerce');

   // @ for postcode
   $address_fields['postcode']['label'] = __('Zipcode', 'woocommerce');

   return $address_fields;
}
// Ocultar ¿ENVIAR A UNA DIRECCIÓN DIFERENTE?
add_filter( 'woocommerce_cart_needs_shipping_address', '__return_false');


add_action( 'woocommerce_review_order_before_payment', 'order_before_payment' );

function order_before_payment() {
   echo '<h3>Selecciona un método de pago</h3>';
}

add_action( 'woocommerce_review_order_before_payment', 'mi_contenido_checkout', 11 );
function mi_contenido_checkout() {
 echo '<div class="cd-tipoEnvio"><strong>Importante:</strong> Los productos deberán ser recogidos en una de nuestras sedes. Elige la sede en la que deseas recoger tu pedido (Palacé, Enviado o Apartadó).  </div>';
}


remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
add_action( 'woocommerce_single_product_summary', 'the_content', 20 );

/**
 * Remove product data tabs
 */
add_filter( 'woocommerce_product_tabs', 'woo_remove_product_tabs', 98 );

function woo_remove_product_tabs( $tabs ) {

    unset( $tabs['description'] );      	// Remove the description tab
    unset( $tabs['reviews'] ); 			// Remove the reviews tab
	unset( $tabs['additional_information'] );  	// Remove the additional information tab
    return $tabs;
}

add_filter('gettext',  'translate_text');
add_filter('ngettext',  'translate_text');
 
function translate_text($translated) {
     $translated = str_ireplace('Dirección de facturación',  'DATOS DEL COMPRADOR',  $translated);
     return $translated;
}

/* / -------------------------------------------- CARRITO*/